#include "GenericTypeDefs.h"
#include "mystring.h"
#include <math.h>
#include "main.h"
#include "uart.h"

#pragma udata mystringdata

#pragma code usercode

BYTE* myultoa(DWORD Value, BYTE* Buffer, unsigned int setprinted)
{
	BYTE i;
	DWORD Digit;
	DWORD Divisor;
	BOOL  Printed;
	
	Printed=FALSE;	
	for(i=0, Divisor=1000000000; i<10; i++)
	{
			if(((10-i)==setprinted)||(i==9))Printed=TRUE;
			Digit = Value/Divisor;
			if(Digit||Printed)
			{
				*Buffer++='0'+Digit;
				Value-=Digit*Divisor;
				Printed=TRUE;
			}
			Divisor/=10;
	}
	*Buffer = '\0';
	return Buffer;
}

unsigned char* uftoa(unsigned char* outstr, float f, int numdec)
{
	char i;
	char j;
	unsigned long k;
	unsigned char iBuffer[16];
 
	if(numdec>6)numdec=6; else if(numdec<0)numdec=0;
	if(f>=0.0)
	{ 
	
	} 
	else 
	{ 
		*outstr++='-'; 
		f=-f; 
	}
	j=(char)numdec;
	while(j>0)
	{
	f*=10.0;
	j--;
	}
	f+=0.5;
	k=(unsigned long)f;
	if(k==0)
	{ 
		iBuffer[0]='0'; 
		iBuffer[1]='\0'; 
	} 
	else 
	{
		myultoa(k, (BYTE*)&iBuffer[0], 0);
	}
	j=(char)stringLength((unsigned char*)&iBuffer[0]);
	j-=(char)numdec;
	if(j<1)
    {
	 *outstr++='0';
   	 *outstr++='.';
   	 j++;
    while(j<1)
    {
        *outstr++='0';
        j++;
    }   
    j=-1; 
    }
             
	i=0;
    while((iBuffer[i]!='\0')&&(i<16))
	{
		if(i==j)*outstr++='.';
		*outstr++=iBuffer[i++];
	}
	*outstr='\0';
	return outstr;
}

unsigned char* ftoa(unsigned char* outstr, float f, int numdec)
{
	unsigned long k;
	
	if(f>=0.0)
	{ 
		*outstr++='+';
	} 
	else 
	{ 

	}
	return uftoa(outstr, f, numdec);
}

unsigned char* getFileSizeString(float f, unsigned char* outstr)
{
	unsigned char* ptr;
	
	if((f>=0.0)&&(f<1000.0))
	{
		ptr=uftoa(outstr, f, 0);
		*ptr++=' ';
		*ptr++='B';		
	}
	else
		if(f<(1000000.0))
		{
			ptr=uftoa(outstr, f/1000.0, 2);
			*ptr++=' ';
			*ptr++='K';
			*ptr++='B';
		}
		else
			if(f<(1000000000.0))
			{
				ptr=uftoa(outstr, f/(1000000.0), 2);
				*ptr++=' ';
				*ptr++='M';
				*ptr++='B';
			}
			else
			{
				ptr=uftoa(outstr, f/(1000000000.0), 2);
				*ptr++=' ';
				*ptr++='G';
				*ptr++='B';
			}
	*ptr='\0';
	return ptr;
}

int stringLength(unsigned char* instr)
{
	int i;
	i=0;
	while((*instr)!='\0')
	{
		i++;
		instr++;
	}
	return i;
}

unsigned char* copyStringRom(unsigned char* first, const rom unsigned char* second)
{
	// copy second string to first
	while((*second)!='\0')
	{
	*first++=*second++;
	}
	*first='\0';
	return first;
}

unsigned char isFileChar(unsigned char c)
{
	unsigned char result;
	
	result=1;
	switch(c)
	{
		default:
			break;
		
		case '(':
		case ')':
		case '*':
		case '?':
		case ':':
		case '<':
		case '>':
		case '|':
		case '"':
		case ' ':
			result=0;
			break;
	}
	return result;
}

unsigned char* copyFileStringString(unsigned char* first, unsigned char* second)
{
	unsigned char c;
	// copy second string to first
	while((*second)!='\0')
	{
		c=*second;
		if(isFileChar(c))*first++=c;
		second++;
	}
	*first='\0';
	return first;
}

unsigned char cmpStringRom(unsigned char* first, const rom unsigned char* second)
{
	unsigned char result;
	
	result=1;
	while((result)&&((*second)!='\0'))
	{
		if((*second)!=(*first))result=0;
		second++;
		first++;
	}
	if((*first)==(*second))
	{
	
	}
	else
	{
		result=0;
	}
	return result;
}

unsigned char* copyString(unsigned char* first, unsigned char* second)
{
	// copy second string to first
	while((*second)!='\0')
	{
	*first++=*second++;
	}
	*first='\0';
	return first;
}

unsigned char* myultoabase(unsigned long Value, unsigned char* Buffer, unsigned char setprinted, unsigned char base, unsigned char maxDigits, unsigned char spaceChar)
{
	unsigned char num;
	unsigned char i;
	unsigned long Digit;
	unsigned long Divisor;
	unsigned char Printed;
	
	switch(base)
	{
		case 2:
			Divisor=0x40000000;
			num=31;
			break;
			
		case 8:
			Divisor=0x40000000;
			num=11;
			break;
		
		default:
		case 10:
			Divisor=100000000;
			num=9;	
			break;
			
		case 16:
			Divisor=0x10000000;
			num=8;
			break;
	}	
	Printed=0;
	i=0;
	while((i<num)&&(i<maxDigits))
	{
		if((num-i)==setprinted)Printed=1;
		if(i==(num-1))Printed=2;
		Digit=Value/Divisor;
		if((Digit==0)&&(Printed==1))
		{
			*Buffer++=spaceChar;
		}
		else
		if(Digit||Printed)
		{
			if((Digit>=0)&&(Digit<=9))
			{
				*Buffer++='0'+(BYTE)Digit;
			}
			else
			if((Digit>=10)&&(Digit<=15))
			{
				*Buffer++='A'+(BYTE)Digit-10;
			}
			Value-=Digit*Divisor;
			Printed=2;
		}
		Divisor/=base;
		i++;
	}
	*Buffer='\0';
	return Buffer;
}

unsigned char* getResultString(unsigned char* outstr, unsigned char result)
{
	if(result)
	{
		outstr=copyStringRom(outstr, (const rom unsigned char*)"Ok");
	}
	else
	{
		outstr=copyStringRom(outstr, (const rom unsigned char*)"Error");
	}
	return outstr;
}
		   	
